package com.syc.function;

import org.xvolks.jnative.JNative;
import org.xvolks.jnative.Type;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.MemoryBlockFactory;

/**
 * 
 * @author Snail
 * @version v1.0
 *
 */

/**
 *RFIDUSBӿڣLinuxµJavaӿࡣʹøðʱ뽫Function.jar,jNative.jar,libfunction.so,libJNativeCpp.soƵĿ¼¡ Function.jar,jNative.jarӿڰ<br/> <br/>
 *<b>ֵ</b><br/>
 *0x00 ִгɹ  <br/>
 *0x01 ʧܣʧԭοײ㵥Ƭϴ<br/>
 *0x02 ַУ<br/>
 *0x03 ûѡCOM<br/>
 *0x04 дسʱ<br/>
 *0x05 ݰˮŲȷ <br/>
 *0x07 쳣<br/>
 *0x0A  ֵΧ <br/> <br/>
 *<b>ײ㵥Ƭϴ</b><br/>
 *0x80 óɹ<br/>
 *0x81 ʧ<br/>
 *0x82 ͨѶʱ <br/>
 *0x83 <br/>
 *0x84 տݳ<br/>
 *0x87 δ֪Ĵ<br/>
 *0x85 ʽ<br/>
 *0x8f ָ벻<br/>
 *0x8A ڶڿʼгִ󣨽14443<br/>
 *0x8B ڷͻеõкţ14443<br/>
 *0x8C ֤ûͨ14443<br/>
 *0x90 ֧15693<br/>
 *0x91 ʽд󣨽15693<br/>
 *0x92 FLAGУ֧OPTION ģʽ15693<br/>
 *0x93 ҪBLOCKڣ15693<br/>
 *0x94 ҪĶѾܽ޸ģ15693<br/>
 *0x95 ɹ15693<br/>
 *0x96 дɹ15693<br/>
 */

public class Function {
	private static String functionLib = "libfunction.so";

	private static Pointer getPointer(byte[] s) {
		try {
			Pointer pointer = new Pointer(
					MemoryBlockFactory.createMemoryBlock(s.length));
			for (int i = 0; i < s.length; i++) {
				pointer.setByteAt(i, s[i]);
			}
			return pointer;
		} catch (Exception e) {
			System.out.print("Failed to get Pointer Data!");
			return null;
		}
	}

	private static void getPointerData(Pointer p, byte[] s) {
		try {
			for (int i = 0; i < p.getSize(); i++) {
				s[i] = p.getAsByte(i);
			}
		} catch (Exception e) {
			System.out.print("Failed to get Pointer Data!");
		}
	}

	private static int loadCommand(String functionName, int... parameter) {
		JNative n = null;
		try {
			n = new JNative(functionLib, functionName);
			n.setRetVal(Type.INT);
			int i = 0;
			for (int p : parameter) {
				n.setParameter(i++, p);
			}
			n.invoke();
			return Integer.parseInt(n.getRetVal());
		} catch (Exception e) {
			System.out.print("Failed to load libfunction.so");
			return 1;
		}
	}

	/**
	 * ϵͳ 8ֽڵĲƷкš
	 * @param newValue 8ֽڵĶдк.
	 * @param buffer ؽյ.
	 * @return 0x00	óɹ.<br/>
	 * 0x01	ʧ.<br/><br/>
	 * óɹ<br/>
	 * buffer=0x80<br/>
	 * ʧܣ<br/>
	 * bufferΪײ㣨ƬϴĴ롣
	 */
	public static int API_SetSerNum(byte[] newValue, byte[] buffer) {
		Pointer newValuePtr = getPointer(newValue);
		Pointer bufferPtr = getPointer(buffer);
		int result = loadCommand("API_SetSerNum", newValuePtr.getPointer(),
				bufferPtr.getPointer());
		getPointerData(bufferPtr, buffer);
		return result;
	}

	/**
	 * ϵͳȡɳԤ1ֽڵĶַ8ֽкš
	 * @param buffer ؽյݡ
	 * @return 0x00	óɹ.<br/>
	 * 0x01	ʧ.<br/><br/>
	 * buffer[0] дַ<br/>
	 * buffer[1...8] 8ֽڵĶдкš
	 */
	public static int API_GetSerNum(byte[] buffer) {
		Pointer bufferPtr = getPointer(buffer);
		int result = loadCommand("API_GetSerNum", bufferPtr.getPointer());
		getPointerData(bufferPtr, buffer);
		return result;
	}

	/**
	 * ϵͳṩ4飨ÿ鲻ܴ120ֽڣ480ֽڿռûûԸҪӦûϢдС
	 * @param num_blk š
	 * @param num_length ݳȡ
	 * @param user_info ûݡ
	 * @return 0x00	óɹ.<br/>
	 * 0x01	ʧ.
	 */
	public static int WriteUserInfo(int num_blk, int num_length,
			byte[] user_info) {
		Pointer user_infoPtr = getPointer(user_info);
		int result = loadCommand("WriteUserInfo", num_blk, num_length,
				user_infoPtr.getPointer());
		getPointerData(user_infoPtr, user_info);
		return result;
	}

	/**
	 * ϵͳȡṩ4飨ÿ鲻ܴ120ֽڣݡ
	 * @param num_blk š
	 * @param num_length ȡݳȡ
	 * @param user_info û 
	 * @return 0x00	óɹ.<br/>
	 * 0x01	ʧ.
	 */
	public static int ReadUserInfo(int num_blk, int num_length, byte[] user_info) {
		Pointer user_infoPtr = getPointer(user_info);
		int result = loadCommand("ReadUserInfo", num_blk, num_length,
				user_infoPtr.getPointer());
		getPointerData(user_infoPtr, user_info);
		return result;
	}

	/**
	 * ϵͳȡдİ汾.
	 * @param VersionNum İ汾š
	 * @return 0x00	óɹ.<br/>
	 * 0x01	ʧ.
	 */
	public static int GetVersionNum(byte[] VersionNum) {
		Pointer VersionNumPtr = getPointer(VersionNum);
		int result = loadCommand("GetVersionNum", VersionNumPtr.getPointer());
		getPointerData(VersionNumPtr, VersionNum);
		return result;
	}

	/**
	 * ϵͳõƵĹ״̬ԼѭĴ
	 * @param freq 
	 * @param duration 
	 * @param buffer صĲ
	 * @return 0x00	óɹ.<br/>
	 * 0x01	ʧ.<br/><br/>
	 * ʧܣ  buffer[0]Ϊ 롣<br/>
	 * ɹ  buffer[0]Ϊɹ־ Ϊ0x80
	 */
	public static int API_ControlLED(byte freq, byte duration, byte[] buffer) {
		Pointer bufferPtr = getPointer(buffer);
		int result = loadCommand("API_ControlLED", freq, duration,
				bufferPtr.getPointer());
		getPointerData(bufferPtr, buffer);
		return result;
	}

	/**
	 * ϵͳ÷Ĺ״̬ĹԼѭĴ
	 * @param freq 
	 * @param duration 
	 * @param buffer صĲ
	 * @return 0x00	óɹ.<br/>
	 * 0x01	ʧ.<br/><br/>
	 * ʧܣ  buffer[0]Ϊ 롣<br/>
	 * ɹ  buffer[0]Ϊɹ־ Ϊ0x80
	 */
	public static int API_ControlBuzzer(byte freq, byte duration, byte[] buffer) {
		Pointer bufferPtr = getPointer(buffer);
		int result = loadCommand("API_ControlBuzzer", freq, duration,
				bufferPtr.getPointer());
		getPointerData(bufferPtr, buffer);
		return result;
	}

	/**
	 * ISO14443AISO14443 A Ѱָ
	 * @param inf_mode Ѱģʽ<br/>
	 * 0x52CIdleģʽһֻһſ<br/>
	 * 0x26CAllģʽһοɶԶſ
	 * @param buffer
	 * @return 0x00	óɹ.<br/>
	 * 0x01	ʧ.<br/><br/>
	 * ʧܣ  snr[0]Ϊ 롣<br/>
	 * ɹ  buffer[0..1]2ֽڵݴ
	 */
	public static int MF_Request(byte inf_mode, byte[] buffer) {
		Pointer bufferPtr = getPointer(buffer);
		int result = loadCommand("MF_Request", inf_mode, bufferPtr.getPointer());
		getPointerData(bufferPtr, buffer);
		return result;
	}

	/**
	 * ISO14443A⿨Ƭ࿨4ֽڵĿšжſͷһſĿţ
	 * @param snr 4ֽڵĿš
	 * @param status ؿƬ
	 * @return 0x00	óɹ.<br/>
	 * 0x01	ʧ.<br/><br/>
	 * ɹ<br/>
	 * status[0] ⵽ĿƬ(0x00ʾ⵽,0x01ʾ⵽࿨)<br/>
	 * snr 4ֽڵĿţsnr[0..3] <br/>
	 * ʧܣ<br/>
	 * snr[0] 롣
	 */
	public static int MF_Anticoll(byte[] snr, byte[] status) {
		Pointer snrPtr = getPointer(snr);
		Pointer statusPtr = getPointer(status);
		int result = loadCommand("MF_Anticoll", snrPtr.getPointer(),
				statusPtr.getPointer());
		getPointerData(snrPtr, snr);
		getPointerData(statusPtr, status);
		return result;
	}

	/**
	 * ISO14443Aʹ뱻ѡ״̬.
	 * @param snr 4ֽڿţҷ4ֽڵĿ.
	 * @return 0x00	óɹ.<br/>
	 * 0x01	ʧ.<br/><br/>
	 * snr 4ֽڵĿţsnr[0..3] 
	 */
	public static int MF_Select(byte[] snr) {
		Pointer snrPtr = getPointer(snr);
		int result = loadCommand("MF_Select", snrPtr.getPointer());
		getPointerData(snrPtr, snr);
		return result;
	}

	/**
	 * ISO14443Aѡ񿨣ʹ뱻жϵ״̬.
	 * @return 0x00	óɹ.<br/>
	 * 0x01	ʧ.
	 */
	public static int MF_Halt() {
		int result = loadCommand("MF_Halt");
		return result;
	}

	/**
	 * ISO14443Aָλöȡָȵ.
	 * @param mode ȡģʽ<br/>
	 * Idle+KeyA mode=00<br/>
	 * Idle+KeyB mode=02<br/>
	 * All+KeyA mode=01<br/>
	 * All+KeyB mode=03<br/>
	 * @param blk_add ȡַ.
	 * @param num_blk ȡĿ.
	 * @param snr ֽڵԿ.
	 * @param buffer ȴ.
	 * @return 0x00	óɹ.<br/>
	 * 0x01	ʧ.<br/><br/>
	 * ɹ:<br/>
	 * snr 4ֽڵĿ.<br/>
	 * buffer ȡ(Ϊnum_blk*16).<br/>
	 * ʧ:<br/>
	 * snr[0] .
	 */
	public static int API_PCDRead(byte mode, byte blk_add, byte num_blk,
			byte[] snr, byte[] buffer) {
		Pointer snrPtr = getPointer(snr);
		Pointer bufferPtr = getPointer(buffer);
		int result = loadCommand("API_PCDRead", mode, blk_add, num_blk,
				snrPtr.getPointer(), bufferPtr.getPointer());
		getPointerData(snrPtr, snr);
		getPointerData(bufferPtr, buffer);
		return result;
	}

	/**
	 * ISO14443Aָλд.
	 * @param mode ȡģʽ<br/>
	 * Idle+KeyA mode=00<br/>
	 * Idle+KeyB mode=02<br/>
	 * All+KeyA mode=01<br/>
	 * All+KeyB mode=03<br/>
	 * @param blk_add Ҫдַ.
	 * @param num_blk ҪдĿ.
	 * @param snr 6ֽ.
	 * @param buffer д.
	 * @return 0x00	óɹ.<br/>
	 * 0x01	ʧ.<br/><br/>
	 * ɹ:<br/>
	 * snr[0..3] 4ֽڵĿ.<br/>
	 * ʧ:<br/>
	 * snr[0] .
	 */
	public static int API_PCDWrite(byte mode, byte blk_add, byte num_blk,
			byte[] snr, byte[] buffer) {
		Pointer snrPtr = getPointer(snr);
		Pointer bufferPtr = getPointer(buffer);
		int result = loadCommand("API_PCDWrite", mode, blk_add, num_blk,
				snrPtr.getPointer(), bufferPtr.getPointer());
		getPointerData(snrPtr, snr);
		return result;
	}

	/**
	 * ISO14443Aʼ.
	 * @param mode ȡģʽ<br/>
	 * Idle+KeyA mode=00<br/>
	 * Idle+KeyB mode=02<br/>
	 * All+KeyA mode=01<br/>
	 * All+KeyB mode=03<br/>
	 * @param SectNum Ҫʼ00-0F.
	 * @param snr 6ֽԿ.
	 * @param value  4 ֽڵҪʼ.
	 * @return 0x00	óɹ.<br/>
	 * 0x01	ʧ.<br/><br/>
	 * ɹ:<br/>
	 * snr[0..3] 4ֽڵĿ.<br/>
	 * ʧ:<br/>
	 * snr[0] .
	 */
	public static int API_PCDInitVal(byte mode, byte SectNum, byte[] snr,
			byte[] value) {
		Pointer snrPtr = getPointer(snr);
		Pointer valuePtr = getPointer(value);
		int result = loadCommand("API_PCDInitVal", mode, SectNum,
				snrPtr.getPointer(), valuePtr.getPointer());
		getPointerData(snrPtr, snr);
		return result;
	}

	/**
	 * ISO14443AԿָмֵ
	 * @param mode ȡģʽ<br/>
	 * Idle+KeyA mode=00<br/>
	 * Idle+KeyB mode=02<br/>
	 * All+KeyA mode=01<br/>
	 * All+KeyB mode=03<br/>
	 * @param SectNum Ҫдֵ00-0F.
	 * @param snr 6ֽԿ.
	 * @param value Ҫֵ4ֽڳ.
	 * @return 0x00	óɹ.<br/>
	 * 0x01	ʧ.<br/><br/>
	 * ɹ:<br/>
	 * snr[0..3] 4ֽڵĿ.<br/>
	 * value[0..3] 4ֽڲݴ.<br/>
	 * ʧ:<br/>
	 * snr[0] .
	 */
	public static int API_PCDDec(byte mode, byte SectNum, byte[] snr,
			byte[] value) {
		Pointer snrPtr = getPointer(snr);
		Pointer valuePtr = getPointer(value);
		int result = loadCommand("API_PCDDec", mode, SectNum,
				snrPtr.getPointer(), valuePtr.getPointer());
		getPointerData(snrPtr, snr);
		return result;
	}

	/**
	 * ISO14443AԿָмֵ
	 * @param mode ȡģʽ<br/>
	 * Idle+KeyA mode=00<br/>
	 * Idle+KeyB mode=02<br/>
	 * All+KeyA mode=01<br/>
	 * All+KeyB mode=03<br/>
	 * @param SectNum Ҫֵ00-0F.
	 * @param snr 6ֽԿ.
	 * @param value Ҫӵֵ4ֽڳ.
	 * @return 0x00	óɹ.<br/>
	 * 0x01	ʧ.<br/><br/>
	 * ɹ:<br/>
	 * snr[0..3] 4ֽڵĿ.<br/>
	 * value[0..3] 4ֽڲݴ.<br/>
	 * ʧ:<br/>
	 * snr[0] .
	 */
	public static int API_PCDInc(byte mode, byte SectNum, byte[] snr,
			byte[] value) {
		Pointer snrPtr = getPointer(snr);
		Pointer valuePtr = getPointer(value);
		int result = loadCommand("API_PCDInc", mode, SectNum,
				snrPtr.getPointer(), valuePtr.getPointer());
		getPointerData(snrPtr, snr);
		return result;
	}

	/**
	 * ISO14443A1ֽڵĵ࿨ʶ4ֽڵĿš
	 * @param mode ģʽ.<br/>
	 * 0x26CIdleģʽһֻһſ.<br/>
	 * 0x52CAllģʽһοɶԶſ).
	 * @param API_halt
	 * @param snr
	 * @param value
	 * @return 0x00	óɹ.<br/>
	 * 0x01	ʧ.<br/><br/>
	 * ɹ:<br/>
	 * snr[0] 1ֽڵĵ࿨ʶ.<br/>
	 * value[0..3] ص4ֽڵĿ.<br/>
	 * ʧ:<br/>
	 * snr[0] .
	 */
	public static int GET_SNR(byte mode, byte API_halt, byte[] snr, byte[] value) {
		Pointer snrPtr = getPointer(snr);
		Pointer valuePtr = getPointer(value);
		int result = loadCommand("GET_SNR", mode, API_halt,
				snrPtr.getPointer(), valuePtr.getPointer());
		getPointerData(snrPtr, snr);
		getPointerData(valuePtr, value);
		return result;
	}

	/**
	 * ISO14443Aѡģʽݵķ.
	 * @param mode ģʽ.<br/>
	 * 0x00ҪCRCУ.<br/>
	 * 0x01ҪCRCУ.
	 * @param cardlength
	 * @param carddata
	 * @return 0x00	óɹ.<br/>
	 * 0x01	ʧ.<br/><br/>
	 * ɹ<br/>
	 * carddata[0..N] շݡ<br/>
	 * ʧܣ<br/>
	 * carddata[0] .
	 */
	public static int MF_Restore(byte mode, int cardlength, byte[] carddata) {
		Pointer carddataPtr = getPointer(carddata);
		int result = loadCommand("MF_Restore", mode, cardlength,
				carddataPtr.getPointer());
		getPointerData(carddataPtr, carddata);
		return result;
	}

	/**
	 * ISO14443BִISO14443BеREQBȡƬPUPI롣
	 * @param buffer Ƭλݴ ATQB
	 * @return 0x00	óɹ.<br/>
	 * 0x01	ʧ.<br/><br/>
	 * ɹ<br/>
	 * buffer ƬλݴATQB.<br/>
	 * buffer[0] Ƭλݵĳ.<br/>
	 * buffer[1..N] ݴATQB.<br/>
	 * ʧܣ<br/>
	 * buffer[0] .
	 */
	public static int RequestType_B(byte[] buffer) {
		Pointer bufferPtr = getPointer(buffer);
		int result = loadCommand("RequestType_B", bufferPtr.getPointer());
		getPointerData(bufferPtr, buffer);
		return result;
	}

	/**
	 * ISO14443BִISO14443BеAnticollB.
	 * @param buffer ƬصݴATQB.
	 * @return 0x00	óɹ.<br/>
	 * 0x01	ʧ.<br/><br/>
	 * ɹ<br/>
	 * buffer[0..N] ƬصݴATQB.<br/>
	 * ʧܣ<br/>
	 * buffer[0] .
	 */
	public static int AntiType_B(byte[] buffer) {
		Pointer bufferPtr = getPointer(buffer);
		int result = loadCommand("AntiType_B", bufferPtr.getPointer());
		getPointerData(bufferPtr, buffer);
		return result;
	}

	/**
	 * ISO14443BִISO14443BеATTRIB֪PUPIĿƬһʶCID.
	 * @param SerialNum к.
	 * @return 0x00	óɹ.<br/>
	 * 0x01	ʧ.
	 */
	public static int SelectType_B(byte[] SerialNum) {
		Pointer SerialNumPtr = getPointer(SerialNum);
		int result = loadCommand("SelectType_B", SerialNumPtr.getPointer());
		getPointerData(SerialNumPtr, SerialNum);
		return result;
	}

	/**
	 * ISO14443BִмISO14443BеģREQUESTATTRIBͨһʹλ
	 * @param buffer زĿк4ֽ.
	 * @return 0x00	óɹ.<br/>
	 * 0x01	ʧ.<br/><br/>
	 * ɹ<br/>
	 * buffer[0..3] زĿк4ֽ.<br/>
	 * ʧܣ<br/>
	 * buffer[0] .
	 */
	public static int Request_AB(byte[] buffer) {
		Pointer bufferPtr = getPointer(buffer);
		int result = loadCommand("Request_AB", bufferPtr.getPointer());
		getPointerData(bufferPtr, buffer);
		return result;
	}

	/**
	 * ISO14443BISO14443ͨ򿨷Ч.
	 * @param cmd ͵.
	 * @param cmdSize ݳ.
	 * @param buffer յ.
	 * @return 0x00	óɹ.<br/>
	 * 0x01	ʧ.<br/><br/>
	 * ɹbuffer[0..N] Ϊӿص.<br/>
	 * ʧܣbuffer[0] Ϊ.
	 */
	public static int API_ISO14443TypeBTransCOSCmd(byte[] cmd, int cmdSize,
			byte[] buffer) {
		Pointer cmdPtr = getPointer(cmd);
		Pointer bufferPtr = getPointer(buffer);
		int result = loadCommand("API_ISO14443TypeBTransCOSCmd",
				cmdPtr.getPointer(), cmdSize, bufferPtr.getPointer());
		getPointerData(bufferPtr, buffer);
		return result;
	}

	/**
	 * ISO15693ͨͻڵõпƬкţܵõĿƬģߵйأһܶ2~6зͻ.
	 * @param flag ʶֽ1ֽ.
	 * @param afi AFIݳ.
	 * @param pData ͵.
	 * @param nrOfCard صĿ.
	 * @param pBuffer صݣFLAGDSFID8[]nֽڵĿţ.
	 * @return 0x00	óɹ.<br/>
	 * 0x01	ʧ.<br/><br/>
	 * ɹ:<br/>
	 * nrOfCard صĿһֽڣ.<br/>
	 * pBuffer صݣFLAGDSFID8*nֽڵĿţ.<br/>
	 * ʧ:<br/>
	 * nrOfCard .
	 */
	public static int API_ISO15693_Inventory(byte flag, byte afi, byte[] pData,
			byte[] nrOfCard, byte[] pBuffer) {
		Pointer pDataPtr = getPointer(pData);
		Pointer nrOfCardPtr = getPointer(nrOfCard);
		Pointer pBufferPtr = getPointer(pBuffer);
		int result = loadCommand("API_ISO15693_Inventory", flag, afi,
				pDataPtr.getPointer(), nrOfCardPtr.getPointer(),
				pBufferPtr.getPointer());
		getPointerData(pDataPtr, pData);
		getPointerData(nrOfCardPtr, nrOfCard);
		getPointerData(pBufferPtr, pBuffer);
		return result;
	}

	/**
	 * ISO15693ȡ1ֵҪÿİȫλFLAGSOption_flagΪ1FLAG = 0X42ÿ5ֽڣ1ʾȫ״ֽ̬ں4ֽڵĿݣʱÿܶ12顣FLAG = 02ֻ4ֽڵĿݣʱÿܶ63顣
	 * @param flags ־λ<br/>
	 * 0x02  uid<br/>
	 * 0x22    uid<br/>
	 * 0x42  uidҪȫλ
	 * @param blk_add Ҫʼš
	 * @param num_blk 
	 * @param uid UIDϢ
	 * @param buffer ֵ
	 * @return 0x00	óɹ.<br/>
	 * 0x01	ʧ.<br/><br/>
	 * ɹ<br/>
	 * buffer[0] صflag<br/>
	 * buffer[1..N] Data<br/>
	 * ʧܣ<br/>
	 * buffer[0]Ϊ롣
	 */
	public static int API_ISO15693Read(byte flags, byte blk_add, byte num_blk,
			byte[] uid, byte[] buffer) {
		Pointer uidPtr = getPointer(uid);
		Pointer bufferPtr = getPointer(buffer);
		int result = loadCommand("API_ISO15693Read", flags, blk_add, num_blk,
				uidPtr.getPointer(), bufferPtr.getPointer());
		getPointerData(uidPtr, uid);
		getPointerData(bufferPtr, buffer);
		return result;
	}

	/**
	 * ISO15693һдÿֻдһ飩
	 * @param flags ־λ<br/>
	 * 0x02  uid<br/>
	 * 0x22    uid<br/>
	 * 0x42  uidҪȫλ
	 * @param blk_add Ҫдʼš
	 * @param num_blk дĿ
	 * @param uid UIDϢ
	 * @param data ֵ
	 * @return 0x00	óɹ.<br/>
	 * 0x01	ʧ.<br/><br/>
	 * ʧܣdata[0]Ϊ
	 */
	public static int API_ISO15693Write(byte flags, byte blk_add, byte num_blk,
			byte[] uid, byte[] data) {
		Pointer uidPtr = getPointer(uid);
		Pointer dataPtr = getPointer(data);
		int result = loadCommand("API_ISO15693Write", flags, blk_add, num_blk,
				uidPtr.getPointer(), dataPtr.getPointer());
		getPointerData(uidPtr, uid);
		getPointerData(dataPtr, data);
		return result;
	}

	/**
	 * ISO15693ݡע⣺˹̲棨ܽݲ޸ġ
	 * @param flags ־λ<br/>
	 * 0x02  uid<br/>
	 * 0x22    uid<br/>
	 * 0x42  uidҪȫλ
	 * @param num_blk ҪĿš
	 * @param uid UIDϢ
	 * @param buffer ֵ
	 * @return 0x00	óɹ.<br/>
	 * 0x01	ʧ.<br/><br/>
	 * ɹbuffer[0]ֵΪ0x80 <br/>
	 * ʧܣbuffer[0]Ϊ롣
	 */
	public static int API_ISO15693Lock(byte flags, byte num_blk, byte[] uid,
			byte[] buffer) {
		Pointer uidPtr = getPointer(uid);
		Pointer bufferPtr = getPointer(buffer);
		int result = loadCommand("API_ISO15693Lock", flags, num_blk,
				uidPtr.getPointer(), bufferPtr.getPointer());
		getPointerData(uidPtr, uid);
		getPointerData(bufferPtr, buffer);
		return result;
	}

	/**
	 * ISO15693ڽھֹ״̬, õַģʽ͵뱻Ŀкͬɹ󣬿뾲ֹ״̬״̬䡣
	 * @param flags ־λ<br/>
	 * 0x02  uid<br/>
	 * 0x22    uid<br/>
	 * 0x42  uidҪȫλ
	 * @param uid UIDϢ
	 * @param buffer ֵ
	 * @return 0x00	óɹ.<br/>
	 * 0x01	ʧ.<br/><br/>
	 * ɹbuffer[0]ֵΪ0x80 <br/>
	 * ʧܣbuffer[0]Ϊ롣
	 */
	public static int API_ISO15693StayQuiet(byte flags, byte[] uid,
			byte[] buffer) {
		Pointer uidPtr = getPointer(uid);
		Pointer bufferPtr = getPointer(buffer);
		int result = loadCommand("API_ISO15693StayQuiet", flags,
				uidPtr.getPointer(), bufferPtr.getPointer());
		getPointerData(uidPtr, uid);
		getPointerData(bufferPtr, buffer);
		return result;
	}

	/**
	 * ISO15693õַģʽ͵뱻Ŀкͬɹ󣬿뱻ѡ״̬״̬䡣
	 * @param flags ־λ<br/>
	 * 0x02  uid<br/>
	 * 0x22    uid<br/>
	 * 0x42  uidҪȫλ
	 * @param uid UIDϢ
	 * @param buffer ֵ
	 * @return 0x00	óɹ.<br/>
	 * 0x01	ʧ.<br/><br/>
	 * ɹbuffer[0]ֵΪ0x80 <br/>
	 * ʧܣbuffer[0]Ϊ롣
	 */
	public static int API_ISO15693Select(byte flags, byte[] uid, byte[] buffer) {
		Pointer uidPtr = getPointer(uid);
		Pointer bufferPtr = getPointer(buffer);
		int result = loadCommand("API_ISO15693Select", flags,
				uidPtr.getPointer(), bufferPtr.getPointer());
		getPointerData(uidPtr, uid);
		getPointerData(bufferPtr, buffer);
		return result;
	}

	/**
	 * ISO15693ɹ󣬿صReady״̬
	 * @param flags ־λ<br/>
	 * 0x02  uid<br/>
	 * 0x22    uid<br/>
	 * 0x42  uidҪȫλ
	 * @param uid UIDϢ
	 * @param buffer ֵ
	 * @return 0x00	óɹ.<br/>
	 * 0x01	ʧ.<br/><br/>
	 * ɹbuffer[0]ֵΪ0x80 <br/>
	 * ʧܣbuffer[0]Ϊ
	 */
	public static int API_ResetToReady(byte flags, byte[] uid, byte[] buffer) {
		Pointer uidPtr = getPointer(uid);
		Pointer bufferPtr = getPointer(buffer);
		int result = loadCommand("API_ResetToReady", flags,
				uidPtr.getPointer(), bufferPtr.getPointer());
		getPointerData(uidPtr, uid);
		getPointerData(bufferPtr, buffer);
		return result;
	}

	/**
	 * ISO15693ԿдAFI
	 * @param flags ־λ<br/>
	 * 0x02  uid<br/>
	 * 0x22    uid<br/>
	 * 0x42  uidҪȫλ
	 * @param afi дAFI.
	 * @param uid UIDϢ
	 * @param buffer ֵ
	 * @return 0x00	óɹ.<br/>
	 * 0x01	ʧ.<br/><br/>
	 * ɹbuffer[0]ֵΪ0x80 <br/>
	 * ʧܣbuffer[0]Ϊ
	 */
	public static int API_WriteAFI(byte flags, byte afi, byte[] uid,
			byte[] buffer) {
		Pointer uidPtr = getPointer(uid);
		Pointer bufferPtr = getPointer(buffer);
		int result = loadCommand("API_WriteAFI", flags, afi,
				uidPtr.getPointer(), bufferPtr.getPointer());
		getPointerData(uidPtr, uid);
		getPointerData(bufferPtr, buffer);
		return result;
	}

	/**
	 * ISO15693AFIAFIԸġ
	 * @param flags ־λ<br/>
	 * 0x02  uid<br/>
	 * 0x22    uid<br/>
	 * 0x42  uidҪȫλ
	 * @param uid UIDϢ
	 * @param buffer ֵ
	 * @return 0x00	óɹ.<br/>
	 * 0x01	ʧ.<br/><br/>
	 * ɹbuffer[0]ֵΪ0x80 <br/>
	 * ʧܣbuffer[0]Ϊ
	 */
	public static int API_LockAFI(byte flags, byte[] uid, byte[] buffer) {
		Pointer uidPtr = getPointer(uid);
		Pointer bufferPtr = getPointer(buffer);
		int result = loadCommand("API_LockAFI", flags, uidPtr.getPointer(),
				bufferPtr.getPointer());
		getPointerData(uidPtr, uid);
		getPointerData(bufferPtr, buffer);
		return result;
	}

	/**
	 * ISO15693ԿĽдDSFID.
	 * @param flags ־λ<br/>
	 * 0x02  uid<br/>
	 * 0x22    uid<br/>
	 * 0x42  uidҪȫλ
	 * @param DSFID ҪдDSFIDֽڣΪ1ֽ.
	 * @param uid UIDϢ
	 * @param buffer ֵ
	 * @return 0x00	óɹ.<br/>
	 * 0x01	ʧ.<br/><br/>
	 * ɹbuffer[0]ֵΪ0x80 <br/>
	 * ʧܣbuffer[0]Ϊ
	 */
	public static int API_WriteDSFID(byte flags, byte DSFID, byte[] uid,
			byte[] buffer) {
		Pointer uidPtr = getPointer(uid);
		Pointer bufferPtr = getPointer(buffer);
		int result = loadCommand("API_WriteDSFID", flags, DSFID,
				uidPtr.getPointer(), bufferPtr.getPointer());
		getPointerData(uidPtr, uid);
		getPointerData(bufferPtr, buffer);
		return result;
	}

	/**
	 * ISO15693DSFIDDSFIDԸ.
	 * @param flags ־λ<br/>
	 * 0x02  uid<br/>
	 * 0x22    uid<br/>
	 * 0x42  uidҪȫλ
	 * @param uid UIDϢ
	 * @param buffer ֵ
	 * @return 0x00	óɹ.<br/>
	 * 0x01	ʧ.<br/><br/>
	 * ɹbuffer[0]ֵΪ0x80 <br/>
	 * ʧܣbuffer[0]Ϊ
	 */
	public static int API_LockDSFID(byte flags, byte[] uid, byte[] buffer) {
		Pointer uidPtr = getPointer(uid);
		Pointer bufferPtr = getPointer(buffer);
		int result = loadCommand("API_LockDSFID", flags, uidPtr.getPointer(),
				bufferPtr.getPointer());
		getPointerData(uidPtr, uid);
		getPointerData(bufferPtr, buffer);
		return result;
	}

	/**
	 * ISO15693ڵõϸϢοISO15693Эϡ
	 * @param flags ־λ<br/>
	 * 0x02  uid<br/>
	 * 0x22    uid<br/>
	 * 0x42  uidҪȫλ
	 * @param uid UIDϢ
	 * @param buffer ֵ.
	 * @return 0x00	óɹ.<br/>
	 * 0x01	ʧ.<br/><br/>
	 * ɹ<br/>
	 * Buffer [0]:	Flags<br/>
	 * Buffer [1]:	INFO Flags<br/>
	 * Buffer [2..9]:	UID<br/>
	 * Buffer [10]:	DSFID<br/>
	 * Buffer [11]:	AFI<br/>
	 * Buffer [12..N]: Other fields<br/>
	 * ʧܣBuffer[0]  Ϊ롣
	 */
	public static int API_ISO15693_GetSysInfo(byte flags, byte[] uid,
			byte[] buffer) {
		Pointer uidPtr = getPointer(uid);
		Pointer bufferPtr = getPointer(buffer);
		int result = loadCommand("API_ISO15693_GetSysInfo", flags,
				uidPtr.getPointer(), bufferPtr.getPointer());
		getPointerData(uidPtr, uid);
		getPointerData(bufferPtr, buffer);
		return result;
	}

	/**
	 * ISO15693ڻȡĸİȫ״̬λ
	 * @param flag ־λ<br/>
	 * 0x02  uid<br/>
	 * 0x22    uid<br/>
	 * 0x42  uidҪȫλ
	 * @param blkAddr Ҫʼš
	 * @param blkNum Ŀ
	 * @param uid UIDϢ
	 * @param pBuffer ֵ
	 * @return 0x00	óɹ.<br/>
	 * 0x01	ʧ.<br/><br/>
	 * ɹ<br/>
	 * pBuffer صݡ<br/>
	 * pBuffer[0]  صflags<br/>
	 * pBuffer [1..N]  Block security status (İȫ״̬) <br/>
	 * ʧܣpBuffer[0]Ϊ롣
	 */
	public static int API_ISO15693_GetMulSecurity(byte flags, byte blkAddr,
			byte blkNum, byte[] uid, byte[] pBuffer) {
		Pointer uidPtr = getPointer(uid);
		Pointer pBufferPtr = getPointer(pBuffer);
		int result = loadCommand("API_ISO15693_GetMulSecurity", flags, blkAddr,
				blkNum, uidPtr.getPointer(), pBufferPtr.getPointer());
		getPointerData(uidPtr, uid);
		getPointerData(pBufferPtr, pBuffer);
		return result;
	}

	/**
	 * ISO15693һͨûͨԿиֲ
	 * @param cmd Ҫ͵ݡ
	 * @param cmdSize ݳȡ
	 * @param buffer ֵ
	 * @return 0x00	óɹ.<br/>
	 * 0x01	ʧ.<br/><br/>
	 * ɹ<br/>
	 * buffer صݡ<br/>
	 * buffer[0..N] ӿصݡ<br/>
	 * ʧܣbuffer[0]Ϊ롣
	 */
	public static int API_ISO15693TransCOSCmd(byte[] cmd, int cmdSize,
			byte[] buffer) {
		Pointer cmdPtr = getPointer(cmd);
		Pointer bufferPtr = getPointer(buffer);
		int result = loadCommand("API_ISO15693TransCOSCmd",
				cmdPtr.getPointer(), cmdSize, bufferPtr.getPointer());
		getPointerData(cmdPtr, cmd);
		getPointerData(bufferPtr, buffer);
		return result;
	}

	/**
	 * UltralightUltralight
	 * @param mode Ѱģʽ <br/>
	 * 0x00CIdleģʽ<br/>
	 * 0x01CAllģʽ
	 * @param blk_add дš
	 * @param snr 7ֽڵĿš
	 * @param buffer 16ֽڵĿݡ
	 * @return 0x00	óɹ.<br/>
	 * 0x01	ʧ.<br/><br/>
	 * ɹ<br/>
	 * snr 7ֽڵĿ.<br/>
	 * buffer 16ֽڵĿ.<br/>
	 * ʧܣ<br/>
	 * buffer[0] 롣
	 */
	public static int UL_HLRead(byte mode, byte blk_add, byte[] snr,
			byte[] buffer) {
		Pointer snrPtr = getPointer(snr);
		Pointer bufferPtr = getPointer(buffer);
		int result = loadCommand("UL_HLRead", mode, blk_add,
				snrPtr.getPointer(), bufferPtr.getPointer());
		getPointerData(snrPtr, snr);
		getPointerData(bufferPtr, buffer);
		return result;
	}

	/**
	 * UltralightUltralightд
	 * @param mode Ѱģʽ <br/>
	 * 0x00CIdleģʽ<br/>
	 * 0x01CAllģʽ
	 * @param blk_add дš
	 * @param snr 7ֽڵĿš
	 * @param buffer ĸֽڵд뿨ݡ
	 * @return 0x00	óɹ.<br/>
	 * 0x01	ʧ.<br/><br/>
	 * ɹ<br/>
	 * snr 7ֽڵĿ.<br/>
	 * buffer 16ֽڵĿ.<br/>
	 * ʧܣ<br/>
	 * buffer[0] 롣
	 */
	public static int UL_HLWrite(byte mode, byte blk_add, byte[] snr,
			byte[] buffer) {
		Pointer snrPtr = getPointer(snr);
		Pointer bufferPtr = getPointer(buffer);
		int result = loadCommand("UL_HLWrite", mode, blk_add,
				snrPtr.getPointer(), bufferPtr.getPointer());
		getPointerData(snrPtr, snr);
		getPointerData(bufferPtr, buffer);
		return result;
	}

	/**
	 * UltralightUltralightѰָ
	 * @param mode Ѱģʽ <br/>
	 * 0x00CIdleģʽ<br/>
	 * 0x01CAllģʽ
	 * @param snr صĲ 
	 * @return 0x00	óɹ.<br/>
	 * 0x01	ʧ.<br/><br/>
	 * ɹ  snr [0..6]7ֽڵݴ<br/>
	 * ʧܣ  snr [0] Ϊ 롣
	 */
	public static int UL_Request(byte mode, byte[] snr) {
		Pointer snrPtr = getPointer(snr);
		int result = loadCommand("UL_Request", mode, snrPtr.getPointer());
		getPointerData(snrPtr, snr);
		return result;
	}

}